#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits>
using namespace std;
struct Poz 
{
    long long x, y;
    Poz(long long x=0, long long y=0) : x(x), y(y) {}
    bool operator==(const Poz& other) const 
    {
        return x==other.x && y==other.y;
    }
};
long long cr(const Poz& o, const Poz& a, const Poz& b) 
{
    return (a.x-o.x)*(b.y-o.y)-(a.y-o.y)*(b.x-o.x);
}
vector<Poz>kon(vector<Poz>& tacka) 
{
    sort(tacka.begin(),tacka.end(),[](const Poz& a,const Poz& b) 
    {
        return a.x<b.x || (a.x==b.x && a.y<b.y);
    });
    vector<Poz>nis,vis;
    for (const auto& p:tacka) 
    {
        while (nis.size()>=2 && cr(nis[nis.size()-2],nis.back(),p)<= 0) 
        {
            nis.pop_back();
        }
        nis.push_back(p);
    }
    for (int i = tacka.size()-1;i>=0;--i) 
    {
        while (vis.size()>=2 && cr(vis[vis.size()-2],vis.back(),tacka[i])<=0) 
        {
            vis.pop_back();
        }
        vis.push_back(tacka[i]);
    }
    nis.pop_back();
    vis.pop_back();
    nis.insert(nis.end(),vis.begin(),vis.end());
    return nis;
}

long long Pov(const vector<Poz>& hull) 
{
    long long area = 0;
    int n = hull.size();
    for (int i=0;i<n;i++) 
    {
        int j=(i+1)%n;
        area +=hull[i].x*hull[j].y-hull[j].x*hull[i].y;
    }
    return abs(area);
}

int main() 
{
    int N;
    cin>>N;
    vector<Poz>tacka(N);
    for (int i=0;i<N;i++) 
    {
        cin>>tacka[i].x>>tacka[i].y;
    }
    vector<Poz>hull=kon(tacka);
    long long minPov=Pov(hull);
    for (int i=0;i<hull.size();i++) 
    {
        vector<Poz>novaPoz=tacka;
        novaPoz.erase(remove(novaPoz.begin(),novaPoz.end(),hull[i]),novaPoz.end());

        vector<Poz>newHull=kon(novaPoz);
        minPov=min(minPov,Pov(newHull));
    }
    cout<<minPov/2<<endl;
    return 0;
}